<?php
require_once 'config.php';
require_once 'musicbrainz_api.php';

$stmt = $pdo->query("SELECT id, artist, title FROM tracks WHERE genre IS NULL OR mood IS NULL OR tags IS NULL");

$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($rows as $row) {
    echo "🎯 Checking '{$row['title']}' by {$row['artist']}...\n";
    $data = fetchMusicBrainzMetadata($row['artist'], $row['title']);

    if ($data) {
        $update = $pdo->prepare("
            UPDATE tracks 
            SET album = IFNULL(album, :album), tags = :tags, scraped_at = NOW() 
            WHERE id = :id
        ");
        $update->execute([
            ':id' => $row['id'],
            ':tags' => implode(', ', $data['tags'] ?? []),
            ':album' => $data['release'] ?? null
        ]);
        echo "✅ Updated metadata for: {$row['title']}\n";
    } else {
        echo "⚠️ No data found for '{$row['title']}'\n";
    }
}
?>
