<?php
require_once 'config.php';
require_once 'spotify_api.php';
require_once 'Track.php';

echo "🚀 Starting full track enrichment sync...\n";

// Step 1: Get access token
$access_token = getAccessToken();
if (!$access_token) {
    die("❌ Failed to get Spotify access token\n");
}

// Step 2: Fetch liked tracks
$offset = 0;
$limit = 50;
$totalFetched = 0;
$inserted = 0;

do {
    $data = fetchLikedTracks($access_token, $offset, $limit);
    $items = $data['items'] ?? [];

    if (empty($items)) break;

    foreach ($items as $index => $item) {
        $track = $item['track'] ?? null;
        if (!$track) continue;

        saveTrack($track);
        $inserted++;
    }

    $fetched = count($items);
    $totalFetched += $fetched;
    $offset += $limit;

    echo "⏳ Processed $totalFetched tracks...\n";
} while (!empty($items));

echo "🎉 Finished enrichment. Processed: $totalFetched | Inserted/Updated: $inserted\n";
?>
