<?php
require_once 'config.php';

$stmt = $pdo->query("
    SELECT spotify_id, COUNT(*) as count 
    FROM tracks 
    GROUP BY spotify_id 
    HAVING count > 1
");

$dupes = $stmt->fetchAll(PDO::FETCH_ASSOC);
foreach ($dupes as $d) {
    $id = $d['spotify_id'];
    echo "🚫 Duplicate: $id\n";

    // Keep the first, delete the rest
    $pdo->exec("
        DELETE FROM tracks 
        WHERE spotify_id = '$id' 
        AND id NOT IN (
            SELECT min_id FROM (
                SELECT MIN(id) AS min_id 
                FROM tracks 
                WHERE spotify_id = '$id'
            ) AS t
        )
    ");
}
echo "✅ Cleanup complete.\n";
?>
