<?php
require_once '../config.php';
global $pdo;

$updated = 0;

foreach ($_POST['tracks'] as $id => $fields) {
    $stmt = $pdo->prepare("
        UPDATE tracks SET
            bpm = :bpm, camelot = :camelot, genre = :genre,
            style = :style, mood = :mood, theme = :theme
        WHERE id = :id
    ");
    $stmt->execute([
        ':id'      => $id,
        ':bpm'     => $fields['bpm'] ?: null,
        ':camelot' => $fields['camelot'] ?: null,
        ':genre'   => $fields['genre'] ?: null,
        ':style'   => $fields['style'] ?: null,
        ':mood'    => $fields['mood'] ?: null,
        ':theme'   => $fields['theme'] ?: null,
    ]);
    $updated++;
}

echo "✅ Updated $updated track(s). <a href='index.php'>Return</a>";
?>