<?php
require 'config.php';
$stmt = $pdo->query("SELECT id, title, tags FROM tracks ORDER BY title ASC");
$tracks = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Track Tagger</title>
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://unpkg.com/@yaireo/tagify"></script>
  <link rel="stylesheet" href="https://unpkg.com/@yaireo/tagify/dist/tagify.css">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
  <h2>Tag Tracks</h2>
  <table class="table table-bordered">
    <thead>
      <tr><th>Track</th><th>Tags</th></tr>
    </thead>
    <tbody>
      <?php foreach ($tracks as $track): ?>
        <tr>
          <td><?= htmlspecialchars($track['title']) ?></td>
          <td>
            <input type="text" class="tag-input form-control" data-id="<?= $track['id'] ?>" value="<?= htmlspecialchars($track['tags'] ?? '') ?>">
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

<script>
$(function() {
  $.getJSON('get_tags.php', function(suggestions) {
    $('.tag-input').each(function() {
      let input = this;
      let tagify = new Tagify(input, { whitelist: suggestions, enforceWhitelist: false });

      tagify.on('change', function() {
        $.post('update_tags.php', {
          track_id: $(input).data('id'),
          tags: tagify.value.map(t => t.value).join(',')
        });
      });
    });
  });
});
</script>
</body>
</html>
