<?php
require 'config.php';

header('Content-Type: application/json');
ob_clean();

$id = $_POST['id'] ?? null;
$tag = trim($_POST['tag'] ?? '');

if (!$id || !$tag) {
    echo json_encode(['error' => 'Missing ID or tag']);
    exit;
}

try {
    // Fetch current tags
    $stmt = $pdo->prepare("SELECT tags FROM tracks WHERE id = ?");
    $stmt->execute([$id]);
    $current = $stmt->fetchColumn();

    $tagArray = array_filter(array_map('trim', explode(',', $current ?? '')));
    
    if (!in_array($tag, $tagArray)) {
        $tagArray[] = $tag;
    }

    $newTags = implode(', ', $tagArray);

    $update = $pdo->prepare("UPDATE tracks SET tags = ? WHERE id = ?");
    $update->execute([$newTags, $id]);

    echo json_encode(['success' => true, 'tags' => $tagArray]);
} catch (PDOException $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
