hh<?php
require 'config.php';
$tracks = $pdo->query("SELECT id, title, artist, camelot, bpm, duration, spotify_id FROM tracks ORDER BY artist, title")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Mobile Playlist Builder</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    .badge-diagonal { background-color: #8e44ad; color: #fff; }
    .badge-mood     { background-color: #000; color: #fff; }
    .badge-jaws     { background-color: #5bc0de; color: #000; }
    .bpm-triangle   { font-weight: bold; display: inline-block; }
    .spotify-player iframe { width: 100%; height: 80px; border: none; }
    .playlist-entry { background: #f8f9fa; border: 1px solid #ccc; padding: 8px; margin-bottom: 5px; border-radius: 5px; }
  </style>
</head>
<body class="container py-3">

  <h4 class="text-center mb-3">📱 DJ Playlist Builder (Mobile)</h4>

  <!-- Spotify Preview Player -->
  <div class="spotify-player mb-3">
    <iframe id="spotifyEmbed" allow="autoplay; clipboard-write; encrypted-media; fullscreen; picture-in-picture"></iframe>
  </div>

  <!-- Playlist Area -->
  <h5>Your Playlist</h5>
  <div id="playlistArea" class="mb-4"></div>

  <!-- Track Selection -->
  <label for="trackSelect" class="form-label">Start From:</label>
  <select id="trackSelect" class="form-select mb-3">
    <option value="">-- Choose Track --</option>
    <?php foreach ($tracks as $t): ?>
      <?php
        $duration = gmdate("i:s", intval(floatval($t['duration']) * 60));
        $camelotColors = [ "1A"=>"#00bcd4","2A"=>"#03a9f4","3A"=>"#2196f3","4A"=>"#3f51b5","5A"=>"#673ab7",
                           "6A"=>"#9c27b0","7A"=>"#e91e63","8A"=>"#f44336","9A"=>"#ff5722","10A"=>"#ff9800",
                           "11A"=>"#ffc107","12A"=>"#ffeb3b","1B"=>"#4caf50","2B"=>"#8bc34a","3B"=>"#cddc39",
                           "4B"=>"#ffeb3b","5B"=>"#ffc107","6B"=>"#ff9800","7B"=>"#ff5722","8B"=>"#f44336",
                           "9B"=>"#e91e63","10B"=>"#9c27b0","11B"=>"#673ab7","12B"=>"#3f51b5" ];
        $color = $camelotColors[$t['camelot']] ?? '#ccc';
      ?>
      <option value="<?= $t['id'] ?>" data-camelot="<?= $t['camelot'] ?>" data-color="<?= $color ?>" data-bpm="<?= $t['bpm'] ?>">
        <?= htmlspecialchars($t['artist']) ?> - <?= htmlspecialchars($t['title']) ?> (<?= $t['bpm'] ?> BPM, <?= $t['camelot'] ?>)
      </option>
    <?php endforeach; ?>
  </select>

  <button id="recommendBtn" class="btn btn-primary w-100 mb-3">🎯 Recommend Tracks</button>
<button id="addSelectedToPlaylist" class="btn btn-outline-primary btn-sm mt-2">➕ Add Starting Track to Playlist</button>

  <!-- Recommendations -->
  <div id="recommendations">
    <h5>Recommendations</h5>
    <div id="recommendList"></div>
  </div>

  <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
  <script>
    let playlist = [];

    const getCamelotColor = key => ({
      '1A':'#00bcd4','2A':'#03a9f4','3A':'#2196f3','4A':'#3f51b5','5A':'#673ab7',
      '6A':'#9c27b0','7A':'#e91e63','8A':'#f44336','9A':'#ff5722','10A':'#ff9800',
      '11A':'#ffc107','12A':'#ffeb3b','1B':'#4caf50','2B':'#8bc34a','3B':'#cddc39',
      '4B':'#ffeb3b','5B':'#ffc107','6B':'#ff9800','7B':'#ff5722','8B':'#f44336',
      '9B':'#e91e63','10B':'#9c27b0','11B':'#673ab7','12B':'#3f51b5'
    }[key] || '#666');

    const getBadgeColor = (type) => {
      switch (type) {
        case 'Perfect Mix':
        case '+1 Mix':
        case '-1 Mix': return 'bg-success';
        case 'Energy Boost': return 'bg-warning';
        case 'Scale Change': return 'bg-primary';
        case "Jaw's Mix": return 'badge-jaws';
        case 'Diagonal Mix': return 'badge-diagonal';
        case 'Mood Shifter': return 'badge-mood';
        default: return 'bg-light';
      }
    };

    function renderPlaylistItem(t, mixType) {
      const badge = mixType ? `<span class="badge ${getBadgeColor(mixType)}">${mixType}</span>` : '';
      const camelot = `<span class="badge" style="background-color:${getCamelotColor(t.camelot)};color:#fff">${t.camelot}</span>`;

      return `<div class="track-entry d-flex justify-content-between align-items-center" data-id="${t.id}">
        <div>
          <div><strong>${t.artist}</strong> - ${t.title}</div>
          <small>BPM: ${t.bpm}, ${camelot} ${badge}</small>
        </div>
        <button class="btn btn-sm btn-danger removeTrack">−</button>
      </div>`;
    }

    function renderRecommendation(t, mixType) {
      const badge = mixType ? `<span class="badge ${getBadgeColor(mixType)}">${mixType}</span>` : '';
      const camelot = `<span class="badge" style="background-color:${getCamelotColor(t.camelot)};color:#fff">${t.camelot}</span>`;

      return `<div class="track-entry d-flex justify-content-between align-items-center">
        <div>
          <div><strong>${t.artist}</strong> - ${t.title}</div>
          <small>BPM: ${t.bpm}, ${camelot} ${badge}</small>
        </div>
        <div>
          <button class="btn btn-sm btn-outline-success addTrack" data-track='${JSON.stringify(t)}' data-mix="${mixType}">+</button>
          <button class="btn btn-sm btn-outline-dark preview" data-spotify="${t.spotify_id}">▶️</button>
        </div>
      </div>`;
    }

$(document).on('click', '.addTrack', function () {
    const t = JSON.parse($(this).data('track'));
    const mix = $(this).data('mix');

    if (!playlist.includes(t.id)) {
        playlist.push(t.id);

        $('#emptyMessage').remove();

        // Add to playlist visually
        $('#playlistArea').append(renderPlaylistItem(t, mix));

        // Set this track as the selected value in the dropdown
        $('#trackSelect').val(t.id).trigger('change');

        // Trigger recommended refresh
        $('#recommendBtn').click();
    }
});

$('#addSelectedToPlaylist').click(function () {
    const selectedId = $('#trackSelect').val();
    if (!selectedId) return alert("Please select a track first.");

    const selectedOption = $('#trackSelect option:selected');
    const artist = selectedOption.data('artist');
    const title = selectedOption.data('title');
    const bpm = selectedOption.data('bpm');
    const camelot = selectedOption.data('camelot');

    if (playlist.includes(selectedId)) return alert("Track already in playlist.");

    playlist.push(selectedId);

    const camelotBadge = `<span class="badge" style="background-color:${getCamelotColor(camelot)};color:#fff">${camelot}</span>`;
    
    const newRow = `<tr data-id="${selectedId}">
        <td>${artist}</td>
        <td>${title}</td>
        <td>${bpm}</td>
        <td>${camelotBadge}</td>
        <td></td>
        <td></td>
        <td></td>
        <td><button class="btn btn-sm btn-outline-danger remove-from-playlist" data-id="${selectedId}">−</button></td>
    </tr>`;

    $('#playlistTable tbody').append(newRow);

    // Refresh recommendations
    $('#recommendBtn').click();
});


    $(document).on('click', '.removeTrack', function () {
      const id = $(this).closest('.track-entry').data('id');
      playlist = playlist.filter(i => i !== id);
      $(this).closest('.track-entry').remove();
    });

    $(document).on('click', '.preview', function () {
      const uri = $(this).data('spotify');
      $('#spotifyEmbed').attr('src', `https://open.spotify.com/embed/track/${uri}?autoplay=1`);
    });

    $('#recommendBtn').click(function () {
      const trackId = $('#trackSelect').val();
      if (!trackId) return;

      $.getJSON('recommend_playlist.php', { track_id: trackId }, function (data) {
        const html = data.map(row => renderRecommendation(row.track, row.mix_type)).join('');
        $('#recommendList').html(html);
      });
    });
  </script>
</body>
</html>