<?php
require 'config.php';
require 'Track.php';

$stmt = $pdo->query("SELECT * FROM tracks");
$tracks = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($tracks as $data) {
    $track = new Track($data);
    $vector = json_encode($track->vector);

    $insert = $pdo->prepare("INSERT INTO tracks_vector (track_id, vector) VALUES (?, ?)
        ON DUPLICATE KEY UPDATE vector = VALUES(vector), updated_at = NOW()");
    $insert->execute([$track->id, $vector]);
}

echo "Vectors built and saved.";
?>
