<?php
require 'config.php';

$camelot = $_GET['camelot'] ?? '';
if (!$camelot) {
    echo json_encode([]);
    exit;
}

$stmt = $pdo->prepare("
    SELECT c.mix_type, t.*
    FROM camelot_map c
    JOIN tracks t ON t.camelot = c.compatible_key
    WHERE c.camelot_key = ?
");
$stmt->execute([$camelot]);

$grouped = [];
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $grouped[$row['mix_type']][] = $row;
}

header('Content-Type: application/json');
echo json_encode($grouped);
